/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug;

import frc.emul.api.IAddressBinder;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.Instructions;
import frc.emul.mc6809.Regs;
import frc.emul.mc6809.dasm.DasmCore;
import frc.emul.util.PartialReadMemory;
import frc.emul.util.Utils;
import frc.emul.vectrex.VectrexAddrBinder;
import frc.emul.vectrex.debug.TraceEntry;
import frc.emul.vectrex.debug.TraceRecorder;
import frc.emul.vectrex.debug.UITraceEntry;
import java.io.IOException;

public class UITraceEntries {
    private DasmCore dasmCore;
    private Instructions instrs;
    private PartialReadMemory mem;
    private Object[] entries;

    public void setAddressBinder(IAddressBinder iAddressBinder) {
        this.init(false);
        this.dasmCore.setAddrBinder(iAddressBinder);
    }

    public void loadTrace(TraceRecorder traceRecorder) {
        this.init(true);
        int n = traceRecorder.getSize();
        this.entries = new Object[n];
        int n2 = n;
        while (--n2 >= 0) {
            this.entries[n2] = traceRecorder.getEntry(n2);
        }
    }

    public int getSize() {
        return this.entries == null ? 0 : this.entries.length;
    }

    public UITraceEntry getUIEntry(int n) {
        try {
            return (UITraceEntry)this.entries[n];
        }
        catch (ClassCastException classCastException) {
            UITraceEntry uITraceEntry = new UITraceEntry(this, (TraceEntry)this.entries[n], n);
            this.entries[n] = uITraceEntry;
            return uITraceEntry;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public StringBuffer[] disassemble(UITraceEntry uITraceEntry) {
        TraceEntry traceEntry = uITraceEntry.getEntry();
        Regs regs = traceEntry.getRegs();
        int n = regs.PC();
        byte[] byArray = traceEntry.getCode();
        Instruction instruction = this.instrs.fetch(byArray[0], (int)byArray[1]);
        if (instruction == null) {
            return new StringBuffer[]{new StringBuffer(Utils.dump(byArray)), new StringBuffer("*** INVALID OP-CODE ***"), new StringBuffer("DB $").append(Utils.dump(byArray, 0, 1)).append(",$").append(Utils.dump(byArray, 1, 1))};
        }
        this.mem.setContent(byArray, n);
        this.dasmCore.setRegisters(regs);
        return this.dasmCore.DASM(instruction, n + instruction.getOpcodeLen(), null, '\u0000', 0, true);
    }

    private void init(boolean bl) {
        if (this.mem != null) {
            return;
        }
        VectrexAddrBinder vectrexAddrBinder = null;
        if (bl) {
            VectrexAddrBinder vectrexAddrBinder2 = new VectrexAddrBinder();
            try {
                vectrexAddrBinder2.loadVectrexBindings();
                vectrexAddrBinder = vectrexAddrBinder2;
            }
            catch (IOException iOException) {}
        }
        this.instrs = new Instructions(true);
        this.mem = new PartialReadMemory(0, 65536, true);
        this.dasmCore = new DasmCore(this.mem, null, vectrexAddrBinder);
    }
}

